\name{import.ltm}
\alias{import.ltm}
\alias{import.irtpro}
\alias{import.flexmirt}
\title{
	Import item parameters estimates and covariance matrices from IRT software
}
\description{
	Import estimated item parameters and covariance matrix from the R package ltm, 
	IRTPRO and flexMIRT.
}
\usage{
import.ltm(mod, display = TRUE, digits = 4) 

import.irtpro(fnamep, fnamev = NULL, param.number = NULL, fixed = NULL, 
	display = TRUE, digits = 2) 

import.flexmirt(fnamep, fnamev = NULL, param.number = NULL, fixed = NULL, 
	display = TRUE, digits = 2) 
}
\arguments{
	\item{mod}{output object from one of the following functions in the \code{ltm} package:
	\code{rasch}, \code{ltm}, or \code{tpm}.}
	\item{display}{logical; if TRUE coefficients and standard errors are printed.}
	\item{digits}{integer indicating the number of decimal places to be used
		if \code{display} is \code{TRUE}.}
	\item{fnamep}{file name containing the estimated item parameters.}
	\item{fnamev}{file name containing the covariance matrix of the estimated item parameters.}
	\item{param.number}{Integer vector with length equal to the number of parameters
		indicating the parameter number, that is the ordering of the item parameters as given in
		the covariance matrix. This number if provided in the output of IRTPRO and flexMIRT.
		If \code{NULL}, \code{param.number} is generated by the function that imports item parameters.
		See details.}
	\item{fixed}{Integer vector indicating the parameter number of item parameters constrained 
		to a fixed value.}
}
\details{
	If item parameters are estimated using IRTPRO or flexMIRT, the parameter number can be found
	in the -irt.txt file in the table with item parameter estimates and standard
	errors under the column P#.
	\code{param.number} is used to link the item parameters with the covariance matrix.
	The user can avoid to specify this number and check if the function returns
	a correct correspondence between coefficients and standard errors using
	\code{display = TRUE}. If not, \code{param.number} should be specified to obtain 
	a correct correspondence.
	
	Item parameters are imported with the parameterization used by the software to
	estimate the IRT model. The usual IRT parameterization can be obtained later
	by using function \code{\link{modIRT}}.
}
\value{
	A list with components
 	\item{coef}{item parameter estimates.}
	\item{var}{covariance matrix of item parameter estimates.}
}
\references{
	Cai L. (2013). \emph{FlexMIRT version 2: Flexible Multilevel Multidimensional Item Analysis and
	Test Scoring [Computer Software]}. Chapel Hill, NC: Vector Psychometric Group.
	
	Cai, L., du Toit, S. H. C., Thissen, D. (2011). \emph{IRTPRO: Flexible, multidimensional, multiple 
	categorical IRT modeling [Computer software]}. Chicago: Scientific Software International.
	
	Rizopoulos, D. (2006). ltm: an R package for latent variable modelling 
	and item response theory analyses. \emph{Journal of Statistical Software}, 
	\bold{17}, 1--25.
}
\author{
	Michela Battauz
}
\seealso{
	\code{\link{modIRT}}
}
\examples{
\dontrun{
library(ltm)

# one-parameter logistic model
mod1pl<-rasch(LSAT)
est.mod1pl<-import.ltm(mod1pl)
est.mod1pl

# two-parameter logistic model
data(data2pl)
m1<-ltm(data2pl[[1]] ~ z1)
estm1<-import.ltm(m1, display = FALSE)
}
}
