% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqn2svg.R
\name{eqn2svg}
\alias{eqn2svg}
\title{Convert a LaTeX math formula to an SVG object}
\usage{
eqn2svg(eqn, preview = TRUE)
}
\arguments{
\item{eqn}{The LaTeX equation text.}

\item{preview}{Should a preview of the formula be shown? By default this is
\code{TRUE}.}
}
\value{
A length 1 character vector containing \code{<SVG>} tag text.
}
\description{
This function converts a LaTeX math formula to an SVG object. All text in the
resulting SVG is in the form of SVG \code{<path>}s. The single-length vector
is a standalone \code{<svg>} tag with the following attributes in place:
\itemize{
\item xmlns:
\item width and height: automatically set in \code{ex} units
\item viewBox: automatically set to provide some padding around the formula
\item stroke and fill: the stroke width is \code{0} and the fill color is set to
the \code{currentColor}
}
}
\examples{
# Take LaTeX code for the Heaviside
# Function and convert that to SVG
heaviside <-
  eqn2svg(
    eqn = l_time_domain[25],
    preview = FALSE
  )

# Take LaTeX code for the Laplace
# transform of that function and
# obtain an SVG
heaviside_laplace <-
  eqn2svg(
    eqn = l_laplace_s_domain[25],
    preview = FALSE
  )
}
