% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{createNeuroTable}
\alias{createNeuroTable}
\title{Main function to call everything and produce the results}
\usage{
createNeuroTable(coocepso, coocesso, coocepi)
}
\arguments{
\item{coocepso}{list of drug names sorted by frequency co-occuring with EpSO}

\item{coocesso}{list of drug names sorted by frequency co-occuring with ESSO}

\item{coocepi}{list of drug names sorted by frequency co-occuring with EPILONT}
}
\value{
result table containin the aggregated list of drug terms and their associations
}
\description{
Main function to call everything and produce the results
}
\examples{
utils::data(rawDrugBankCoOcEpSO, package="epos")
utils::data(rawDrugBankCoOcESSO, package="epos")
utils::data(rawDrugBankCoOcEPILONT, package="epos")
createNeuroTable(coocepso = rawDrugBankCoOcEpSO[1:150], 
  coocesso=rawDrugBankCoOcESSO[1:150],
  coocepi=rawDrugBankCoOcEPILONT[1:150])
}
