% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simulated_epidemics}
\alias{simulated_epidemics}
\title{Examples of simulated epidemic data.}
\format{A data frame with 864 rows and 6 variables:
\tabular{rll}{
    [, 1]   \tab pattern \tab Either clumped (i.e. aggregated), random or
                              regular. \cr
    [, 2]   \tab mu      \tab Median spore dispersal parameter. \cr
    [, 3:4] \tab x,y     \tab Grid spatial coordinates. \cr
    [, 5]   \tab i       \tab Number of diseased plants (from 0 to 100). \cr
    [, 6]   \tab n       \tab Sampling unit size. Here, n = 100 plants per
                              sampling unit. \cr
}}
\source{
Xu XM, Madden LV. 2004. Use of SADIE statistics to study spatial
  dynamics of plant disease epidemics. Plant Pathology 53, 38–49.
  \href{http://dx.doi.org/10.1111/j.1365-3059.2004.00949.x}{doi:10.1111/j.1365-3059.2004.00949.x}
}
\usage{
simulated_epidemics
}
\description{
Epidemics were generated using the stochastic simulator from Xu and Madden
(2004). The data consist of the numbers of diseased plants per sampling
unit (out of a total of n = 100 plants in each sampling unit). N = 144
sampling units, and different values for the parameters \code{pattern} and
\code{mu} were used for the simulations.
}
\keyword{datasets}
