% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health.r
\name{get_health_insurance_coverage}
\alias{get_health_insurance_coverage}
\title{Retreive Health Insurance Coverage}
\usage{
get_health_insurance_coverage(by = NULL)
}
\arguments{
\item{by}{\code{NULL} or character string with any combination of \code{g} (Gender),
\code{r} (Race), \code{e} (Education), \code{d} (Percentile), \code{l} (Entry-level)
i.e. if you want to retrieve unemployment data by gender and race, you would set this
parameter to "\code{gr}".}
}
\value{
\code{tbl_df} with data filtered by the selected criteria.
}
\description{
Employer-sponsored health insurance (ESI) coverage shows the share of workers who
received health insurance from their own job for which their employer paid for at
least some of their health insurance coverage.
}
\details{
Population sample: Private-sector workers age 18–64 & at least 20 hours/week and 26 weeks/year
}
\note{
Data source: CPS ASEC
}
\examples{
get_health_insurance_coverage()

get_health_insurance_coverage("r")

get_health_insurance_coverage("gr")
}
\references{
\href{http://www.epi.org/data/}{Economic Policy Institute Data Library}
}
