% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consistency_check.R
\name{consistency_check}
\alias{consistency_check}
\title{Consistency Check Function}
\usage{
consistency_check(data, tests, cases)
}
\arguments{
\item{data}{A data frame containing the test and case data.}

\item{tests}{A character vector specifying the column names for the test
data.}

\item{cases}{A character vector specifying the column names for the case
data. The length of 'tests' and 'cases' must be the same, and each element
in 'tests' corresponds to an element in 'cases'.}
}
\value{
A \code{\link[=ggplot2]{ggplot2::ggplot()}} object showing
the consistency between the number of tests and cases. The x-axis represents
the cases, and the y-axis represents the tests. Each facet represents a
disease, and the diagonal line shows where the number of tests equals the
number of cases.
}
\description{
This function performs a consistency check to ensure that the number of tests
is greater than the number of cases for given columns in a dataset. It
returns a \code{\link[=ggplot2]{ggplot2}} object visualizing the results.
}
\examples{
# check the consistency between malaria tests and cases

# get path
path <- system.file(
        "extdata",
        "fake_epi_df_togo.rds",
         package = "epiCleanr")

fake_epi_df_togo <- import(path)

consistency_check(fake_epi_df_togo,
                  tests = c("malaria_tests","cholera_tests"),
                  cases = c("malaria_cases", "cholera_cases"))


}
