% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.R
\name{boxcoxTransform}
\alias{boxcoxTransform}
\title{Box-Cox transformation of data - Only intended for developer use}
\usage{
boxcoxTransform(x)
}
\arguments{
\item{x}{a numeric vector of data values.}
}
\value{
A list is returned with elements:
\item{lambda}{a numeric value giving power parameter}
\item{x}{a numeric vector of data values}
\item{x.transformed}{a numeric vector of transformed data}
}
\description{
Performs Box-Cox power transformation of the data. The optimal value of power parameter is selected based on profile log-likelihoods.
The function is called by \code{\link{KRDetect.outliers.changepoint}} and is not intended for use by regular users of the package.
}
\details{
This function computes the Box-Cox power transformation of the data.
The function is exported for developer use only. It does not perform any checks on inputs since it is only a convenience function for a transformation of data to normality.
The optimal value of a power parameter is estimated based on profile log-likelihoods calculated using \code{boxcox} function implemented in \pkg{MASS} package.
}
\references{
Box G, Cox D (1964). An analysis of transformations. Journal of the Royal Statistical Society: Series B, 26, 211–234.

Venables WN, Ripley BD (2002). Modern Applied Statistics with S. New York, fourth edition. ISBN 0-387-95457-0, URL http://www.stats.ox.ac.uk/pub/MASS4.
}
