#' @family calibration
#' 
#' @title ICP-AES calibration data
#' 
#' @description
#' Sample data of the calibration of silver ions in four-fold replication using
#' inductively coupled plasma atomic emission spectroscopy (ICP-AES).
#' 
#' @format
#' A data frame containing 16 rows and 6 columns with information on:
#' 
#' \describe{
#'   \item{Label}{sample name}
#'   \item{Element}{element name}
#'   \item{Conc}{nominal concentration}
#'   \item{Units}{concentration units}
#'   \item{Signal}{signal intensity [cps]}
#'   \item{Replicate}{number of the respective replicate}
#' }
#' 
#' @author
#' Zacharias Steinmetz
#' 
#' @docType data
#' @keywords data
#' @name icp
NULL
