#' @title Calibration data from DIN 32645
#' 
#' @description
#' Sample data for the calibration of carbon in water.
#' 
#' @format
#' A data frame containing 20 rows and 2 columns with information on:
#' \tabular{ll}{
#' Conc: \tab nominal concentration in mg/L\cr
#' Area: \tab measurement signal\cr
#' }
#' 
#' @references 
#' DIN 32645:2008-11, 2008. Chemical analysis - Decision limit, detection limit
#' and determination limit under repeatability conditions - Terms, methods,
#' evaluation (Technical standard). Deutsches Institut für Normung, Berlin.
#' 
#' @seealso
#' \code{\link{calibration}}
#' 
#' @docType data
#' @keywords data
#' @name din32645
NULL
