% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble.R
\name{ensemble}
\alias{ensemble}
\title{Perform Ensemble modelling using Caret Package.}
\usage{
ensemble(training, testing, outcomeName, BaseModels, TopModel)
}
\arguments{
\item{training}{a dataset containing the outcome varable with all other independent variables.}

\item{testing}{a dataset containing all the independent variable columns as well as outcome variable column with NULL values i.e. must have same no. of columns as the training dataset}

\item{outcomeName}{the column name associated with outcome variable in the training dataset.}

\item{BaseModels}{character string vector containing the names of all base models as in 'caret package' desired to be used for ensembling.}

\item{TopModel}{name of the model as in 'caret package' that is wished to be used on top.}
}
\value{
predictions the estimated outcome variables column for testing dataset.
}
\description{
Take any number of Machine Learning Models as Base Models and one Machine Learning Model as Top model to produce an ensemble of models.
}
\examples{
data(iris)
preds <- ensemble(iris[1:125,],iris[125:150,],'Species',c('treebag','rpart'),'rpart')
table(preds)

}

