% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.enpls.R
\name{predict.enpls.fit}
\alias{predict.enpls.fit}
\title{Make Predictions from a Fitted Ensemble Partial Least Squares Model}
\usage{
\method{predict}{enpls.fit}(object, newx, method = c("mean", "median"),
  ...)
}
\arguments{
\item{object}{An object of class \code{enpls.fit}.}

\item{newx}{New data to predict with.}

\item{method}{Use \code{"mean"} or \code{"median"} to create
the final prediction.}

\item{...}{Additional parameters for \code{\link{predict}}.}
}
\value{
A numeric vector containing the predicted values.
}
\description{
Make predictions on new data by fitted enpls.fit object.
}
\examples{
data("alkanes")
x <- alkanes$x
y <- alkanes$y

set.seed(42)
fit <- enpls.fit(x, y, reptimes = 50)
y.pred <- predict(fit, newx = x)
plot(y, y.pred, xlim = range(y), ylim = range(y))
abline(a = 0L, b = 1L)
y.pred.med <- predict(fit, newx = x, method = "median")
plot(y, y.pred.med, xlim = range(y), ylim = range(y))
abline(a = 0L, b = 1L)
}
\seealso{
See \code{\link{enpls.fit}} for fitting ensemble
partial least squares regression models.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
