% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genkeys.R
\name{genkeys}
\alias{genkeys}
\title{Create and write RSA private and public keys}
\usage{
genkeys(private_key_name = "id_rsa",
  public_key_name = paste0(private_key_name, ".pub"))
}
\arguments{
\item{private_key_name}{Character string. Do not change default unless good
reason.}

\item{public_key_name}{Character string. Do not change default unless good
reason.}
}
\value{
Two files containing the public key and encrypted private key are
  written to the working directory.
}
\description{
The first step for the \code{encryptr} workflow is to create a pair of
encryption keys. This uses the \code{\link{openssl}} package. The public key
is used to encrypt information and can be shared. The private key allows
decryption of the encrypted information. It requires a password to be set.
This password cannot be recovered if lost. If the file is lost or
overwritten, any data encrypted with the public key cannot be decrypted.
}
\examples{
# Function can be used as this:
# genkeys()

# For CRAN purposes and testing
genkeys(file.path(tempdir(), "id_rsa"))

}
\seealso{
encrypt decrypt
}
