% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-database.DBconfig.R
\name{AddListRemoveLabelGroup}
\alias{AddListRemoveLabelGroup}
\alias{add_labelGroup}
\alias{list_labelGroups}
\alias{remove_labelGroup}
\title{Add / List / Remove global labelGroup to / of / from emuDB}
\usage{
add_labelGroup(emuDBhandle, name, values)

list_labelGroups(emuDBhandle)

remove_labelGroup(emuDBhandle, name)
}
\arguments{
\item{emuDBhandle}{emuDB handle as returned by \code{\link{load_emuDB}}}

\item{name}{name of label group}

\item{values}{character vector of labels}
}
\description{
Add / List / Remove label group that can be used as a short hand  
to reference groups of labels that are globally defined
for the entire database (compared to attribute definition
specific label groups that 
are added by \code{\link{add_attrDefLabelGroup}}) in a 
\code{\link{query}}. A common example would be to
add a label group for something like the phonetic
category of nasals to be able to reference them 
as "nasals" in a \code{\link{query}}. 
In theory you could use a labelGroupName as a label instance within the
level, but since this could lead to serious confusion, it is better avoided.
For users transitioning from the legacy EMU system: Do not confuse a 
labelGroup with legal labels: a labelGroup 
had the unfortunate name 'legal labels' in the legacy EMU system.  
For more information on the structural elements of an emuDB 
see \code{vignette{emuDB}}.
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

sampaNasals = c("m", "F", "n", "J", "N")

# add these values to the ae emuDB
# as a globally available labelGroup
add_labelGroup(emuDBhandle = ae,
               name = "sampaNasals",
               values = sampaNasals)

# query the labelGroup in the "Phonetic" level
query(emuDBhandle = ae, 
      query = "Phonetic == sampaNasals")

# query the labelGroup in the "Phoneme" level
query(emuDBhandle = ae, 
      query = "Phoneme == sampaNasals")

# list global label groups of ae emuDB
list_labelGroups(emuDBhandle = ae)

# remove the newly added labelGroup
remove_labelGroup(emuDBhandle = ae,
                  name = "sampaNasals")
}

}
\seealso{
add_attrDefLabelGroup
}
\keyword{Emu}
\keyword{database}
\keyword{emuDB}
\keyword{schema}
