% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{emojis}
\alias{emojis}
\title{Full List of Emojis}
\format{
tibble with 19 columns and \code{nrow(emojis)} rows
\describe{
\item{emoji}{character representation of the emoji}
\item{name}{name}
\item{group}{group, e.g. "Smileys & People"}
\item{subgroup}{sub group, e.g. "face-positive"}
\item{version}{version where the emoji was introduced}
\item{points}{Decimal Code Point(s)}
\item{nrunes}{number of runes the emoji uses}
\item{runes}{vector of unicode runes, i.e. hexadecimal representations
prefixed with "U+"}
\item{qualified}{Status of the emoji, can be one of 4 types; "component",
"fully-qualified", "minimally-qualified", and
"unqualified". See details for more.}
\item{vendor_* for apple ... windows}{logical indicating if the given
vendor supports the emoji}
\item{keywords}{vector of keywords}
\item{keywords}{vector of aliases}
}
}
\source{
\href{https://www.unicode.org/emoji/charts-13.1/full-emoji-list.html}{Unicode® Full Emoji Charts v13.1}

\href{https://www.unicode.org/emoji/charts-13.1/emoji-list.html}{Unicode® Emoji Charts v13.1}

\href{https://www.unicode.org/emoji/charts/emoji-ordering.txt}{Unicode® Emoji Ordering, v13.1}

\url{https://github.com/github/gemoji}

\url{https://github.com/muan/emojilib}
}
\usage{
emojis
}
\description{
This data set is the heart of the emoji package. It contains various
information regarding all the avaiable emojis as of v13.1.
}
\details{
The levels of \code{qualified} have the following meaining
\itemize{
\item \strong{component}: an Emoji_Component, excluding Regional_Indicators, ASCII, and
non-Emoji.
\item \strong{fully-qualified}: a fully-qualified emoji (see ED-18 in UTS #51), excluding
Emoji_Component
\item \strong{minimally-qualified}: a minimally-qualified emoji (see ED-18a in UTS #51)
\item \strong{unqualified}: a unqualified emoji (See ED-19 in UTS #51)
}
}
\seealso{
emoji_name emoji_keyboard
}
\keyword{datasets}
