% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoji_p.R
\name{emoji_p}
\alias{emoji_p}
\title{Summarise your p-values with emoji}
\usage{
emoji_p(
  x,
  names = c("laughing", "joy", "grin", "smile", "thinking", "poop"),
  cutpoints = c(1e-05, 0.001, 0.01, 0.05, 0.1),
  legend = FALSE
)
}
\arguments{
\item{x}{A vector of p-values.}

\item{names}{A character vector, for each of the p-value cutoff points.
The names are being passed to \code{emoji()}.}

\item{cutpoints}{A numeric vector of cutpoints between emojis.}

\item{legend}{Logical, denotes if the result should be returned with a
legend.}
}
\description{
Summarise your p-values with emoji
}
\details{
This function is vectorized. The input \code{cutpoints} must be 1 shorter than the
\code{names} input. The input \code{cutpoints} should not include 0 or 1 and be in
accending order.
}
\examples{
set.seed(1234)
emoji_p(1)
emoji_p(0.1)
emoji_p(0.05)
emoji_p(0.01)
emoji_p(1e-6)

emoji_p(0.01, legend = TRUE)

emoji_p(rbeta(50, 2, 5))

emoji_p(
  runif(100, 0, 0.1),
  names = c("flexed biceps", "hundred points", "thumbs down", "thumbs up"),
  cutpoints = c(0.001, 0.01, 0.05)
)
}
