% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{joint_tests}
\alias{joint_tests}
\title{Compute joint tests of the terms in a model}
\usage{
joint_tests(object, by = NULL, show0df = FALSE, showconf = (length(facs)
  < 4), cov.reduce = range, ...)
}
\arguments{
\item{object, cov.reduce}{\code{object} is a fitted model or an \code{emmGrid}. 
If a fitted model, it is
replaced by \code{ref_grid(object, cov.reduce = cov.reduce, ...)}}

\item{by}{character names of \code{by} variables. Separate sets of tests are
run for each combination of these.}

\item{show0df}{logical value; if \code{TRUE}, results with zero numerator
degrees of freedom are displayed, if \code{FALSE} they are skipped}

\item{showconf}{logical value; if \code{true}, we look for additional effects 
that are not purely due to contrasts of a single term, and if found, are
labeled \code{(confounded)}. Such effects can occur, e.g., when there are empty
cells in the data. Setting this to \code{FALSE} can save some computation
time, especially when there are a lot of factors. The default is based on
the internal vector \code{facs}, which is the number of factors being
considered.}

\item{...}{additional arguments passed to \code{ref_grid} and \code{emmeans}}
}
\value{
a \code{summary_emm} object (same as is produced by 
  \code{\link{summary.emmGrid}}). All effects for which there are no
  estimable contrasts are omitted from the results. 
  There may be an additional row named \code{(confounded)} which accounts
  for joint tests of effects that are estimable but are not 
  determined by contrasts of any one term.
  The returned object also includes an \code{"est.fcns"} attribute, which is a
  named list containing the linear functions associated with each joint test. 
  The order of this list may not be the same as the order of the summary.
}
\description{
This function produces an analysis-of-variance-like table based on linear
functions of predictors in a model or \code{emmGrid} object. Specifically,
the function constructs, for each combination of factors (or covariates
reduced to two or more levels), a set of (interaction) contrasts via
\code{\link{contrast}}, and then tests them using \code{\link{test}} with
\code{joint = TRUE}. Optionally, one or more of the predictors may be used as
\code{by} variable(s), so that separate tables of tests are produced for
each combination of them.
}
\details{
In models with only factors, no covariates, we believe these tests correspond
to \dQuote{type III} tests a la \pkg{SAS}, as long as equal-weighted
averaging is used and there are no estimability issues. When covariates are
present and interact with factors, the results depend on how the covariate is
handled in constructing the reference grid. See the example at the end of
this documentation. The point that one must always remember is that
\code{joint_tests} always tests contrasts among EMMs, in the context of the
reference grid, whereas type III tests are tests of model coefficients --
which may or may not have anything to do with EMMs or contrasts.
}
\note{
When we have models with estimability issues (e.g., missing cells), the results
can depend on what contrast method is used. The default is 
\code{use.contr = c("consec", "eff")}, meaning that we use \code{"consec"} comparisons
for constructing [interaction] contrasts for named terms, and \code{"eff"} contrasts
for constructing contrasts for confounded effects (we construct the latter overall, then
remove any linear dependence on the named contrasts). You may override these defaults
via a hidden option: specify \code{use.contr = <character 2-vector>} among the arguments.
Examining the \code{"est.fcns"} attribute may help understand what you are testing,
but the more redundant the contrast method, the more redundant are the estimable
functions.
}
\examples{
pigs.lm <- lm(log(conc) ~ source * factor(percent), data = pigs)

(jt <- joint_tests(pigs.lm))             ## will be same as type III ANOVA

### Estimable functions associated with "percent"
attr(jt, "est.fcns") $ "percent"

joint_tests(pigs.lm, weights = "outer")  ## differently weighted

joint_tests(pigs.lm, by = "source")      ## separate joint tests of 'percent'

### Comparisons with type III tests
toy = data.frame(
    treat = rep(c("A", "B"), c(4, 6)),
    female = c(1, 0, 0, 1,   0, 0, 0, 1, 1, 0 ),
    resp = c(17, 12, 14, 19, 28, 26, 26, 34, 33, 27))
toy.fac = lm(resp ~ treat * factor(female), data = toy)
toy.cov = lm(resp ~ treat * female, data = toy)
# (These two models have identical fitted values and residuals)

# -- SAS output we'd get with toy.fac --
## Source          DF    Type III SS    Mean Square   F Value   Pr > F
## treat            1    488.8928571    488.8928571    404.60   <.0001
## female           1     78.8928571     78.8928571     65.29   0.0002
## treat*female     1      1.7500000      1.7500000      1.45   0.2741
# 
# -- SAS output we'd get with toy.cov --
## Source          DF    Type III SS    Mean Square   F Value   Pr > F
## treat            1    252.0833333    252.0833333    208.62   <.0001
## female           1     78.8928571     78.8928571     65.29   0.0002
## female*treat     1      1.7500000      1.7500000      1.45   0.2741

joint_tests(toy.fac)
joint_tests(toy.cov)   # female is regarded as a 2-level factor by default

# results for toy.cov depend on value we use for 'female'
joint_tests(toy.cov, at = list(female = 0.5))
joint_tests(toy.cov, cov.keep = 0)   # i.e., female = mean(toy$female)
joint_tests(toy.cov, at = list(female = 0))

### Example with empty cells and confounded effects
low3 <- unlist(attr(ubds, "cells")[1:3]) 
ubds.lm <- lm(y ~ A*B*C, data = ubds, subset = -low3)
joint_tests(ubds.lm, by = "B")

}
\seealso{
\code{\link{test}}
}
