## ---- echo = FALSE, results = "hide", message = FALSE--------------------
require("emmeans")
knitr::opts_chunk$set(fig.width = 4.5, class.output = "ro")

## ------------------------------------------------------------------------
pigs.lm <- lm(log(conc) ~ source + factor(percent), data = pigs)
pigs.rg <- ref_grid(pigs.lm)
class(pigs.rg)

pigs.emm.s <- emmeans(pigs.rg, "source")
class(pigs.emm.s)

## ------------------------------------------------------------------------
pigs.rg

pigs.emm.s

## ------------------------------------------------------------------------
str(pigs.emm.s)

## ------------------------------------------------------------------------
class(summary(pigs.emm.s))

## ------------------------------------------------------------------------
test(pigs.emm.s)

## ------------------------------------------------------------------------
test(pigs.emm.s, null = log(40), side = ">")

## ------------------------------------------------------------------------
test(pigs.emm.s, null = log(40), side = ">", type = "response")

## ------------------------------------------------------------------------
confint(pigs.emm.s, side = ">", level = .90, type = "response")

## ------------------------------------------------------------------------
confint(pigs.emm.s, adjust = "tukey")

## ------------------------------------------------------------------------
test(pigs.emm.s, null = log(40), side = ">", adjust = "bonferroni")

## ------------------------------------------------------------------------
confint(pigs.rg, by = "source")

## ----eval = FALSE--------------------------------------------------------
#  emmeans(pigs.lm, ~ percent | source)     ### same results as above
#  summary(.Last.value, by = percent)       ### grouped the other way

## ------------------------------------------------------------------------
pigsint.lm <- lm(log(conc) ~ source * factor(percent), data = pigs)
pigsint.rg <- ref_grid(pigsint.lm)
contrast(pigsint.rg, "consec", simple = "percent")

## ------------------------------------------------------------------------
pigs.prs.s <- pairs(pigs.emm.s)
pigs.prs.s

## ------------------------------------------------------------------------
test(pigs.prs.s, joint = TRUE)

## ------------------------------------------------------------------------
joint_tests(pigsint.rg)

## ------------------------------------------------------------------------
test(pigs.prs.s, delta = log(1.25), adjust = "none")

