% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cld-emm.R
\name{CLD}
\alias{CLD}
\alias{CLD.emmGrid}
\alias{CLD}
\alias{cld.emmGrid}
\title{Extract and display information on all pairwise comparisons of least-squares means.}
\usage{
CLD(object, ...)

\method{CLD}{emmGrid}(object, details = FALSE, sort = TRUE, by,
  alpha = 0.05, Letters = c("1234567890", LETTERS, letters),
  reversed = FALSE, ...)

\method{cld}{emmGrid}(object, ...)
}
\arguments{
\item{object}{An object of class \code{emmGrid}}

\item{...}{Arguments passed to \code{\link{contrast}} (for example, 
  an \code{adjust} method)

This function uses the Piepho (2004) algorithm (as implemented in the 
\pkg{multcompView} package) to generate a compact letter display of all
pairwise comparisons of least-squares means. The function obtains (possibly
adjusted) P values for all pairwise comparisons of means, using the
\code{\link{contrast}} function with \code{method = "pairwise"}. When a P
value exceeds \code{alpha}, then the two means have at least one letter in
common.}

\item{details}{Logical value determining whether detailed information on tests of 
pairwise comparisons is displayed}

\item{sort}{Logical value determining whether the EMMs are sorted before the comparisons 
are produced. When \code{TRUE}, the results are displayed according to 
\code{reversed}.}

\item{by}{Character value giving the name or names of variables by which separate 
families of comparisons are tested. If NULL, all means are compared. 
If missing, the object's \code{by.vars} setting, if any, is used.}

\item{alpha}{Numeric value giving the significance level for the comparisons}

\item{Letters}{Character vector of letters to use in the display. Any strings of 
length greater than 1 are expanded into individual characters}

\item{reversed}{Logical value (passed to \code{multcompView::multcompLetters}.) 
If \code{TRUE}, the order of use of the letters is reversed. 
In addition, if both \code{sort} and \code{reversed} are TRUE, the sort 
order of results is reversed.}
}
\value{
When details == FALSE, an object of class \code{summary.ref_grid}
  (which inherits from \code{data.frame}) showing the summary of EMMs with 
  an added column named \code{.groups} containing the \code{CLD} information. 
  When \code{details == TRUE}, a \code{list} with the object just described, 
  as well as the summary of the contrast results showing each comparison, 
  its estimate, standard error, t ratio, and adjusted P value.
}
\description{
Extract and display information on all pairwise comparisons of least-squares means.
}
\examples{
warp.lm <- lm(breaks ~ wool * tension, data = warpbreaks)
warp.emm <- emmeans(warp.lm, ~ tension | wool)
CLD(warp.emm)                  # implicitly uses by = "wool"
CLD(warp.emm, by = "tension")  # overrides implicit 'by'

# Mimic grouping bars and compare all 6 means
CLD(warp.emm, by = NULL, Letters = "||||||||", alpha = .01)
}
\references{
Hans-Peter Piepho (2004) An algorithm for a letter-based representation 
  of all pairwise comparisons, Journal of Computational and Graphical Statistics, 13(2), 
  456-466.
}
\seealso{
\code{cld} in the \pkg{multcomp} package, for which a courtesy
  method is provided for \code{emmGrid} objects.
}
