% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnet.r
\name{fit_glmnet}
\alias{fit_glmnet}
\alias{fit_ridge_regression}
\alias{fit_lasso}
\title{Fit elastic net, LASSO or ridge regression model}
\usage{
fit_glmnet(x, y, family, nfolds, foldid, alpha = 1, lambda = NULL, ...)

fit_ridge_regression(...)

fit_lasso(...)
}
\arguments{
\item{x}{Dataset.}

\item{y}{Response vector. Can be of many different types for solving
different problems, see \code{\link[glmnet]{glmnet}}.}

\item{family}{Determines the the type of problem to solve. Auto detected if
\code{y} is numeric or survival. See \code{\link{family}} for details.}

\item{nfolds}{See \code{\link[glmnet]{cv.glmnet}}.}

\item{foldid}{See \code{\link[glmnet]{cv.glmnet}}.}

\item{alpha}{Regularization parameter, see \code{\link[glmnet]{glmnet}}.}

\item{lambda}{Regularization parameter, see \code{\link[glmnet]{glmnet}}.}

\item{...}{Sent to \code{\link{fit_glmnet}} or \code{\link[glmnet]{cv.glmnet}}.}
}
\value{
Fitted elastic net model.
}
\description{
Using the \pkg{glmnet} package implementation.
}
\details{
The \code{alpha} parameter of \code{\link[glmnet]{glmnet}} controls the type of
penalty. Use \code{0} (default) for lasso only, \code{1} for ridge only, or
an intermediate for a combination. This is typically the parameter to tune
on. The shrinkage, controlled by the \code{lambda} parameter, can be left
unspecified for internal tuning (works the same way as
\code{\link{fit_glmnet}}).
}
\seealso{
\code{\link{emil}}, \code{\link{predict_glmnet}},
  \code{\link{importance_glmnet}}, \code{\link{modeling_procedure}}
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
