% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampling.r
\name{image.resample}
\alias{image.resample}
\alias{image.crossvalidation}
\title{Visualize resampling scheme}
\usage{
\method{image}{resample}(x, col, ...)

\method{image}{crossvalidation}(x, col, ...)
}
\arguments{
\item{x}{Resampling scheme, as returned by \code{\link{resample}}.}

\item{col}{Color palette matching the values of \code{x}.
Can also be the response vector used to create the
scheme for automatic coloring.}

\item{...}{Sent to \code{\link{plot}}.}
}
\value{
Nothing, produces a plot.
}
\description{
Class specific extension to \code{\link{image}}.
}
\examples{
y <- gl(2, 30)
image(resample("crossvalidation", y, nfold=3, nrepeat=8), col=y)
}
\seealso{
\code{\link{emil}}, \code{\link{resample}}
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
