% Generated by roxygen2 (4.0.1): do not edit by hand
\name{p.value.crr}
\alias{p.value.crr}
\title{Extracts p-value from a competing risk model}
\usage{
\method{p.value}{crr}(x, log.p = FALSE, ...)
}
\arguments{
\item{x}{Fitted crr model, as returned by \code{\link[cmprsk]{crr}}.}

\item{log.p}{Whether to return the logarithm of the p-value.}

\item{...}{Ignored. Kept for S3 consistency.}
}
\value{
Two-sided p-value.
}
\description{
Extracts p-value from a competing risk model
}
\examples{
library(cmprsk)
time <- 1:20
event <- c(rep(0, 9), rep(2, 3), rep(1, 8))
data <- rep(0:1, each=10)
x <- crr(time, event, data)

# Compare p-values of implementations
print(x)
p.value(x)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{p.value}}
}

