% Generated by roxygen2 (4.0.1): do not edit by hand
\name{emil.fit.cforest}
\alias{emil.fit.cforest}
\title{Fit conditional inference forest}
\usage{
emil.fit.cforest(x, y, formula = y ~ ., ctrl.fun = cforest_unbiased, ...)
}
\arguments{
\item{x}{Dataset, observations as rows and descriptors as columns.}

\item{y}{Responses.}

\item{formula}{Formula linking response to descriptors.}

\item{ctrl.fun}{Which control function to use, see \code{\link[party]{cforest_control}}.}

\item{...}{Sent to the function specified by \code{ctrl.fun}.}
}
\value{
A fitted \code{\link[party]{cforest}} model.
}
\description{
A \code{\link[party]{cforest}} is a random forest based on conditional inference
trees, using the implementation in the \code{party} package.
These trees can be used for classification, regression or survival
analysis, but only the survival part has been properly tested so far.
}
\details{
The parameters to \code{\link[party]{cforest}} are set using a
\code{\link[party]{cforest_control}} object. You should read the documentation
as the default values are chosen for technical reasons, not predictive
performance!
Pay special attention to \code{mtry} which is set very low by default.
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{emil.predict.cforest}},
  \code{\link{modeling.procedure}}
}

