% Generated by roxygen2 (4.0.1): do not edit by hand
\name{subtree}
\alias{subtree}
\title{Extract a subset of a tree of nested lists}
\usage{
subtree(x, i, ..., error = NULL, simplify = TRUE)
}
\arguments{
\item{x}{List of lists.}

\item{i}{Indexes to extract on the first level of the tree. Can also be a
function that will be applied to the downstream result of the function.}

\item{...}{Indexes to extract on subsequent levels.}

\item{error}{A function to be called if there is an error when parsing
\code{x}, or a value to replace erroneous elements with, see the examples.}

\item{simplify}{Whether to collapse lists of length one (\code{TRUE}) or
preserve the original tree structure (\code{FALSE}).}
}
\value{
A subset of the list tree.
}
\description{
Many functions of the package produce results on the form of nested list,
like \code{\link{evaluate.modeling}}. Use this function to extract only a
subset of the tree. Also note the similar function \code{\link{subframe}}.
}
\details{
This function can only be used to extract data, not to assign.
}
\examples{
l <- list(A=list(a=0:2, b=3:4, c=023-22030),
          B=list(a=5:7, b=8:9))
subtree(l, 1:2, "b")
subtree(l, TRUE, mean, "a")

subtree(l, TRUE, exp, "c", error=browser)
subtree(l, TRUE, exp, "c", error=NA)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{subframe}}
}

