% Generated by roxygen2 (4.0.1): do not edit by hand
\name{pre.impute.knn}
\alias{pre.impute.knn}
\title{kNN imputation}
\usage{
pre.impute.knn(x, y, fold, k = 0.05, distmat)
}
\arguments{
\item{x}{Dataset.}

\item{y}{Response vector.}

\item{fold}{A logical vector with \code{FALSE} for fitting observations,
\code{TRUE} for test observations and \code{NA} for observations not
to be included.}

\item{k}{Number of nearest neighbors to calculate mean from. Set to < 1 to
specify a fraction.}

\item{distmat}{Distance matrix. A matrix, \code{\link{dist}} object or
  \code{"auto"}. Notice that \code{"auto"} will recalculate the distance
  matrix in each fold, which is only meaningful in case the features of
  \code{x} vary between folds. Otherwise you are just wasting time.}
}
\description{
Nearest neighbor methods needs to have a distance matrix of the dataset it works on.
When doing repeated model fittings on subsets of the entire dataset it is
unnecessary to recalculate it every time, therefore this function requires
the user to manually calculate it prior to resampling and supply it in a
wrapper function.
}
\examples{
x <- iris[-5]
x[sample(nrow(x), 30), 3] <- NA
my.dist <- dist(x)
evaluate.modeling(modeling.procedure("lda"), x=x, y=iris$Species,
    pre.process=function(...) pre.impute.knn(..., k=4, my.dist))
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}

