% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_plot.R
\name{compare_plot}
\alias{compare_plot}
\title{Shows plots for the comparison of estimates}
\usage{
compare_plot(
  model,
  direct,
  indicator = "all",
  MSE = FALSE,
  CV = FALSE,
  label = "orig",
  color = c("blue", "lightblue3"),
  shape = c(16, 16),
  line_type = c("solid", "solid"),
  gg_theme = NULL,
  ...
)
}
\arguments{
\item{model}{an object of type "emdi","model", representing point and MSE
estimates.}

\item{direct}{an object of type "emdi","direct", representing point
and MSE estimates. If the input argument \code{model} is of type "model","ebp",
\code{direct} is required. If the input argument \code{model} is of type 
"model","fh", the \code{direct} component is already included in the input 
argument \code{model}.}

\item{indicator}{optional character vector that selects which indicators
shall be returned. Defaults to "all".}

\item{MSE}{optional logical. If \code{TRUE}, the MSE estimates of the direct 
and model-based estimates are compared via suitable plots. Defaults to \code{FALSE}.}

\item{CV}{optional logical. If \code{TRUE}, the coefficient of variation 
estimates of the direct and model-based estimates are compared via suitable plots. 
Defaults to \code{FALSE}.}

\item{label}{argument that enables to customize title and axis labels. There 
are three options to label the evaluation plots: (i) original labels ("orig"), 
(ii) axis labels but no title ("no_title"), (iii) neither axis 
labels nor title ("blank").}

\item{color}{a vector with two elements determining color schemes in returned 
plots.}

\item{shape}{a numeric vector with two elements determining the shape of points
in returned plots.}

\item{line_type}{a character vector with two elements determining the line 
types in returned plots.}

\item{gg_theme}{\code{\link[ggplot2]{theme}} list from package \pkg{ggplot2}.
For using this argument, package \pkg{ggplot2} must be loaded via 
\code{library(ggplot2)}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Plots comparing direct and model-based estimators for each selected 
indicator obtained by \code{\link[ggplot2]{ggplot}}.
}
\description{
Function \code{compare_plot} is a generic function used to produce plots 
comparing point and existing MSE/CV estimates of direct and model-based
estimation for all indicators or a selection of indicators.
}
\details{
Since all of the comparisons need a direct estimator, the plots are 
only created for in-sample domains. For the new package version (2.0.1), the 
order of the input arguments direct and model has been changed. In this version, it 
is still possible to use the old order because the 
arguments are swapped internally. From the next package version on, it will no 
longer be possible.
}
\seealso{
\code{\link{emdiObject}}, \code{\link{direct}}, \code{\link{ebp}}, 
\code{\link{fh}}
}
