% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HatchingSuccess.logLik.R
\name{logLik.HatchingSuccess}
\alias{logLik.HatchingSuccess}
\title{Return -log L of a fit}
\usage{
\method{logLik}{HatchingSuccess}(object, ...)
}
\arguments{
\item{object}{The return of a fit done with fitHS.}

\item{...}{Not used}
}
\value{
Return -log L of a fit
}
\description{
Set of functions to study the hatching success.\cr
}
\details{
logLik.HatchingSuccess returns -log L of a fit
}
\examples{
\dontrun{
library(embryogrowth)
totalIncubation_Cc <- subset(DatabaseTSD, 
                             Species=="Caretta caretta" & 
                               Note != "Sinusoidal pattern" & 
                               !is.na(Total) & Total != 0)

par <- c(S.low=0.5, S.high=0.3, 
         P.low=25, deltaP=10, MaxHS=logit(0.8))
         
HatchingSuccesss.lnL(par=par, data=totalIncubation_Cc)

g <- HatchingSuccess.fit(par=par, data=totalIncubation_Cc)

HatchingSuccesss.lnL(par=g$par, data=totalIncubation_Cc)

t <- seq(from=20, to=40, by=0.1)
CIq <- predict(g, temperature=t)

par(mar=c(4, 4, 1, 1), +0.4)
plot(g)
}
}
\seealso{
Other Hatching success: \code{\link{HatchingSuccess.MHmcmc_p}},
  \code{\link{HatchingSuccess.MHmcmc}},
  \code{\link{HatchingSuccess.fit}},
  \code{\link{HatchingSuccess.lnL}},
  \code{\link{HatchingSuccess.model}},
  \code{\link{nobs.HatchingSuccess}},
  \code{\link{plot.HatchingSuccess}},
  \code{\link{predict.HatchingSuccess}}
}
\author{
Marc Girondot
}
\concept{Hatching success}
