% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Linear.R
\name{dydt.linear}
\alias{dydt.linear}
\title{Return the derivative of the linear function}
\usage{
dydt.linear(t, size, parms)
}
\arguments{
\item{t}{The time in any unit}

\item{size}{The current size}

\item{parms}{A vector with alpha being c(alpha=x1, K=x2). Only alpha is used.}
}
\value{
A list with the derivative
}
\description{
Return the derivative of the linear function\cr
dydt.linear(t, size, parms)
}
\details{
dydt.Linear returns the derivative of the linear function.
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
# The initial parameters value can be:
# "T12H", "DHA",  "DHH", "Rho25"
# Or
# "T12L", "DT", "DHA",  "DHH", "DHL", "Rho25"
x <- structure(c(306.174998729436, 333.708348843241, 299.856306141849,
	149.046870203155), .Names = c("DHA", "DHH", "T12H", "Rho25"))
# K or rK are not used for dydt.linear or dydt.exponential
resultNest_4p_linear <- searchR(parameters=x, fixed.parameters=NULL,
	temperatures=formated, derivate=dydt.linear, M0=1.7,
	test=c(Mean=39.33, SD=1.92))
}
}
\author{
Marc Girondot
}

