% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{get_link_operators_from_models_dir}
\alias{get_link_operators_from_models_dir}
\title{Load the models boolean equation link operator data}
\usage{
get_link_operators_from_models_dir(
  models.dir,
  remove.equations.without.link.operator = TRUE
)
}
\arguments{
\item{models.dir}{string. A directory path with \emph{.gitsbe} files/models.
\strong{Do not} include the ending path character in the string (\emph{/}).}

\item{remove.equations.without.link.operator}{logical. Should we keep the
nodes (columns in the returned matrix) which do not have both type of
regulators (so no link operator)? Default value: TRUE (remove these nodes).}
}
\value{
a \code{data.frame} (nxm) with n models and m nodes. The row names
specify the models' names whereas the column names specify the
network nodes (gene, proteins, etc.). Possible values for each \emph{model-node
element} are either \emph{0} (\strong{and not} link operator), \emph{1}
(\strong{or not} link operator) or \emph{0.5} if the node is not targeted by
both activating and inhibiting regulators (no link operator).
}
\description{
Use this function to merge the link operator data used in the boolean equations
of the models into a single \code{data.frame} object. Every boolean model is defined by a series
of boolean equations in the form \eqn{Target *= (Activator or Activator or...)
and not (Inhibitor or Inhibitor or...)"}. The \strong{link operator} can be
either \emph{and not}, \emph{or not} or non-existent if the target has only
activating regulators or only inhibiting ones (the \emph{not} remains in the
latter case). The models are loaded from
\emph{.gitsbe} files that can be found inside the given \code{models.dir}
directory.
}
\examples{

models.dir = system.file("extdata", "models", package = "emba", mustWork = TRUE)
models.link.operator = get_link_operators_from_models_dir(models.dir)
models.link.operator.with.extra.nodes =
  get_link_operators_from_models_dir(models.dir, FALSE)

}
