% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializers.R
\name{init.random}
\alias{init.random}
\title{Method to initialize EM parameters.  Purely standard normal noise.}
\usage{
init.random(x, K, noise = 1)
}
\arguments{
\item{x}{An \emph{n}-by-\emph{p} design matrix.}

\item{K}{Number of EM classes to be fit.}

\item{noise}{Standard deviation of the white noise to be applied when generating random initial states.}
}
\value{
A K-length list, each holding parameters.
}
\description{
Method to initialize EM parameters.  Purely standard normal noise.
}
\examples{
x <- model.matrix(~ 1 + factor(wool) + factor(tension), data = warpbreaks)

init.random(x = x, K = 2)

}
