% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.glm.R
\name{elo.glm}
\alias{elo.glm}
\title{\code{elo.glm}}
\usage{
elo.glm(formula, data, na.action, subset, family = "binomial", ...,
  rm.ties = TRUE)
}
\arguments{
\item{formula}{A formula. See \link[=formula.specials]{the help page for formulas} for details.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}

\item{family, ...}{Arguments passed to \code{\link[stats]{glm}}.}

\item{rm.ties}{Logical, denoting whether to remove ties on the left-hand side.}
}
\value{
An object of class \code{c("elo.glm", "glm")}.
}
\description{
Compute a logistic regression model for a matchup.
}
\details{
The formula syntax is the same as other \code{elo} functions. A data.frame
  of indicator variables is built, where an entry is 1 if a team is home, 0 if
  a team didn't play, and -1 if a team is a visitor. A \code{\link{glm}} model is then
  run to predict wins.

  With this setup, usually one model term will be NA, as the input is linearly dependent.
  Consider this team's skill to be zero relative to the other teams.
  The intercept represents the home-field advantage.
}
\examples{
data(tournament)
elo.glm(score(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = tournament)

}
\seealso{
\code{\link{score}}, \code{\link{elo.model.frame}}
}
