% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkpt-ymax.R
\name{bkpt_ymax}
\alias{bkpt_ymax}
\title{Identify breakpoint location with Ymax}
\usage{
bkpt_ymax(watershed.df)
}
\arguments{
\item{watershed.df}{A dataframe of sites with ecological and hydrologic data}
}
\value{
Breakpoint value is returned
}
\description{
This applies the Ymax elfgen method. This approach treats the maximum observed species richness value as the breakpoint. This function begins by locating the point with the highest y-value in the full dataset, then utilizing the associated x-value as the breakpoint.
}
\examples{
\donttest{
watershed.df <- elfdata('02080201')
breakpt <- bkpt_ymax(watershed.df)
}
}
