% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtree.R
\name{sample_posterior}
\alias{sample_posterior}
\title{Draw election outcomes from the posterior distribution.}
\usage{
sample_posterior(
  dtree,
  n_elections,
  n_ballots,
  n_winners = 1,
  n_threads = NULL
)
}
\arguments{
\item{dtree}{A \code{dirichlet_tree} object.}

\item{n_elections}{An integer representing the number of elections to generate. A higher
number yields higher precision in the output probabilities.}

\item{n_ballots}{An integer representing the total number of ballots cast in the election.}

\item{n_winners}{The number of candidates elected in each election.}

\item{n_threads}{The maximum number of threads for the process. The default value of
\code{NULL} will default to 2 threads. \code{Inf} will default to the maximum
available, and any value greater than or equal to the maximum available will
result in the maximum available.}
}
\value{
A numeric vector containing the probabilities for each candidate
being elected.
}
\description{
\code{sample_posterior} draws sets of ballots from independent realizations
of the Dirichlet-tree posterior, then determines the probability for each
candidate being elected by aggregating the results of the social choice
function. See \insertCite{dtree_evoteid;textual}{elections.dtree} for
details.
}
\references{
\insertRef{dtree_eis}{elections.dtree}.

\insertRef{dtree_evoteid}{elections.dtree}.
}
