% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_munich.R
\name{to_munich}
\alias{to_munich}
\title{Export emissions to Model of Urban Network of Intersecting Canyons and Highways (MUNICH)}
\usage{
to_munich(sdf, idbrin, typo, width, height, crs = 4326)
}
\arguments{
\item{sdf}{Street Emissions object class 'sf' LINESTRING or "SpatialLinesdataFrame".
The columns are the emissions.}

\item{idbrin}{Integer; id.}

\item{typo}{Integer; id2.}

\item{width}{Integer; width.}

\item{height}{Integer; heigth.}

\item{crs}{Numeric; Coordenade Reference System with default value of 4326.}
}
\value{
A list with a data frame with columns "i", "idbrin", "typo", "xa",
"ya", "xb", "yb" and the pollutants; and another data.frame with "i",
"length" (m), "width" (with value 0) and "height" (with value 0). Width and
height must be obtained by the user.
}
\description{
\code{\link{to_munich}} Export spatial emissions objects
according the format required by MUNICH. This function was designed to
read street emissions from VEIN by it can be used to read any other.
}
\note{
The user must ensure that the spatial object has one line feature
per vertex and lines with more than one vertex must be previously splitted.
the resulting units must be \strong{ug/km/h}
}
\examples{
{
library(vein)
library(units)
library(sf)
data(net)
data(pc_profile)
data(profiles)
data(fkm)
PC_G <- c(33491,22340,24818,31808,46458,28574,24856,28972,37818,49050,87923,
          133833,138441,142682,171029,151048,115228,98664,126444,101027,
          84771,55864,36306,21079,20138,17439, 7854,2215,656,1262,476,512,
          1181, 4991, 3711, 5653, 7039, 5839, 4257,3824, 3068)
pc1 <- my_age(x = net$ldv, y = PC_G, name = "PC")

# Estimation for morning rush hour and local emission factors and speed
speed <- data.frame(S8 = net$ps)
lef <- EmissionFactorsList(ef_cetesb("CO", "PC_G", agemax = ncol(pc1)))
E_CO <- emis(veh = pc1,lkm = net$lkm, ef = lef, speed = speed)
# rowSums drop units
net$CO  <- set_units(rowSums(E_CO), g/h)
# selecting only CO and exploding lines and updating emissions
df <- st_explode(net["CO"])
# st_explode should not drop units, must fix
df$CO  <- set_units(df$CO, g/h)
# now we have split line in vertex
# selecting 1000 links
dfco <- df[1:1000,"CO"]
###########
#MUNICH relies in a python script that reads emissions with units ug/km/h
# Therefore
dfco$CO <- set_units(dfco$CO, ug/h)
dfco$CO<- dfco$CO/set_units(st_length(dfco), km)
etm <- to_munich(sdf = dfco)
names(etm)
class(etm)
head(etm$Emissions)
head(etm$Street)
write.table(x = etm$Emissions, file = paste0(tempfile(), "_Emissions.txt"),
row.names = FALSE, sep = " ", quote = FALSE)
write.table(x = etm$Street, file = paste0(tempfile(), "_Street.txt"),
row.names = FALSE, sep = " ", quote = FALSE)
######
# todo: handle all unit checks and conversion internally
}
}
\references{
Kim, Y., Wu, Y., Seigneur, C., and Roustan, Y.:
Multi-scale modeling of urban air pollution: development and application of
a Street-in-Grid model (v1.0) by coupling MUNICH (v1.0) and Polair3D
(v1.8.1), Geosci. Model Dev., 11, 611-629,
https://doi.org/10.5194/gmd-11-611-2018, 2018.
}
