% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surname_utils.R
\name{get_unique_special_characters}
\alias{get_unique_special_characters}
\title{Gets special characters in a column of names.}
\usage{
get_unique_special_characters(
  voter_file,
  surname_col = "last_name",
  regex = "[A-Za-z]"
)
}
\arguments{
\item{voter_file}{The voter file, with each row consisting of a voter.}

\item{surname_col}{A string denoting the surname column.}

\item{regex}{A string denoting the regular expression to use for identifying
non-special characters (by default, alphabetic characters).}
}
\value{
A vector of unique special characters found in the names.
}
\description{
Returns a unique list of special characters found in a column of a dataframe.
By default, these characters consist of any that are not upper- or lower-case
letters. This preference can be overwritten by providing a new regular
expression.
}
