% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_geocoder.R
\name{run_geocoder}
\alias{run_geocoder}
\title{Geocoding voter file addresses with coordinates (latitude and longitude)
and/or census geographies.}
\usage{
run_geocoder(
  voter_file,
  geocoder = "census",
  parallel = FALSE,
  voter_id = "voter_id",
  street = "street",
  city = "city",
  state = "state",
  zipcode = "residence_zipcode",
  country = NULL,
  census_return = NULL,
  census_benchmark = "Public_AR_Current",
  census_vintage = 4,
  census_output = "single",
  census_class = "sf",
  opencage_key = NULL
)
}
\arguments{
\item{voter_file}{A data frame contain the voter addresses, separated into
columns for street, city, state, and zipcode}

\item{geocoder}{The options for selecting geocoders are "censusxy" and
"opencage".}

\item{parallel}{TRUE or FALSE. The option to run parallel processing on the
data. Running parallel processing requires the user to have at least 4 CPU
cores. Use detectCores() to determine the number of CPUs on your device.}

\item{voter_id}{the unique identifier}

\item{street}{the street number, street name, and/or street suffix.
Ex. 555 Main Street SW}

\item{city}{the location/town}

\item{state}{the abbreviated state (U.S. state categories such as "GA")}

\item{zipcode}{the 5 or 9 digit number in the format XXXXX or XXXXX-XXXX.}

\item{country}{the abbreviated a nation or territory}

\item{census_return}{either "locations" or "geographies". "locations" returns
the latitude and longitude coordinates. "geographies" returns the latitude,
longitude, and FIPS codes for county, state, tract, and block.}

\item{census_benchmark}{a dataset of the snapshot of the US Census data. Data
is collected two times a year. Public_AR_Current is the time period when we
created the snapshot of the data (usually done twice yearly). For example,
Public_AR_Current is the most recent snapshot of our dataset.}

\item{census_vintage}{a dataset that details the survey or census that the
census_benchmark uses.}

\item{census_output}{"single" or "full". "single" indicates that only
latitude and longitude are returned. "full" indicates that latitude,
longitude, and FIPS codes are returned.}

\item{census_class}{"sf" indicates returning a shape file in the R class, sf.
Other file types like "json" and "csv" can also be used.}

\item{opencage_key}{the Opencage Geocoder API key needed to run the Opencage
Geocoder. The use of the key is
limited to the level of membership on Opencage. Only 2500 rquests per day
for free membership.}
}
\value{
The geocoded voter file with either added simple
(latitude and longitude coordinates) or other geographies.
}
\description{
Geocoding voter file addresses with coordinates (latitude and longitude)
and/or census geographies.
}
\author{
Loren Collingwood <loren.collingwood@ucr.edu>

Juandalyn Burke <jcburke@uw.edu>
}
