% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surname_utils.R
\name{predict_race_multi_barreled}
\alias{predict_race_multi_barreled}
\title{Predicts, for one row in a voter file, the probability of a voter having a
certain race by averaging over each "barrel" of the surname.}
\usage{
predict_race_multi_barreled(
  voter_file,
  surname_col = "last_name",
  surname_only = TRUE,
  census_data = NULL,
  census_geo = "block",
  surname_year = 2010,
  use_age = FALSE,
  use_sex = FALSE,
  state = NULL,
  county = NULL,
  tract = NULL,
  block = NULL,
  pattern = "[ -]+",
  remove_patterns = NULL
)
}
\arguments{
\item{voter_file}{The voter file, with each row consisting of a voter.}

\item{surname_col}{A string denoting the surname column.}

\item{surname_only}{Whether to obtain probabilities for surnames only.}

\item{census_data}{A data frame containing Census data corresponding to the
geographic information for units in the voter file.}

\item{census_geo}{The census level at which to apply BISG. Passed to WRU.}

\item{surname_year}{Which Census year to use for surname matching. Passed to
WRU.}

\item{use_age}{Whether to use the age in the BISG calculation. Passed to WRU.}

\item{use_sex}{Whether to use the sex in the BISG calculation. Passed to WRU.}

\item{state}{A string denoting the state for which the data is queried.}

\item{county}{A string denoting the column containing the county FIPS code.}

\item{tract}{A string denoting the column containing the tract FIPS code.}

\item{block}{A string denoting the column containing the block FIPS code.}

\item{pattern}{What pattern to split surnames on. By default, surnames are
split on a space(s), which assumes hyphens have already been removed.}

\item{remove_patterns}{A list of strings which will be removed from the
list of barrels.}
}
\value{
A vector of probabilities for each surname.
}
\description{
Predicts, for one row in a voter file, the probability of a voter having a
certain race by averaging over each "barrel" of the surname.
}
