% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.window.R
\name{age.window}
\alias{age.window}
\title{Age cut of survival data}
\usage{
age.window(dat, window, surv = c("enter", "exit", "event"))
}
\arguments{
\item{dat}{Input data frame. Must contain survival data.}

\item{window}{Vector of length two; the age interval.}

\item{surv}{Vector of length three giving the names of the central variables
in 'dat'.}
}
\value{
A data frame of the same form as the input data frame, but 'cut' as
desired. Intervals exceeding \code{window[2]} will be given \code{event = 0}
}
\description{
For a given age interval, each spell is cut to fit into the given age
interval.
}
\details{
The \code{window} must be in the order \code{(begin, end)}
}
\examples{

dat <- data.frame(enter = 0, exit = 5.731, event = 1, x = 2)
window <- c(2, 5.3)
dat.trim <- age.window(dat, window)  

}
\seealso{
\code{\link{cal.window}}, \code{\link{coxreg}},
\code{\link{aftreg}}
}
\author{
Göran Broström
}
\keyword{survival}
