plot.Surv <- function(x,
                      strata = NULL,
                      fn = c("cum", "surv", "log", "loglog"),
                      limits = TRUE,
                      conf = 0.95,
                      main = NULL,
                      xlab = NULL,
                      ylab = NULL,
                      xlim = NULL,
                      ylim = NULL,
                      lty.con = NULL,
                      col.con = NULL,
                      x.axis = TRUE,
                      ...){
    ## Check input data:

    if (!inherits(x, "Surv"))
        stop("First argument must be of type 'Surv'")

    if (ncol(x) == 3){
        enter <- x[, 1]
        exit <- x[, 2]
        event <- x[, 3]
        n <- length(exit)
    }else{
        exit <- x[, 1]
        n <- length(exit)
        enter <- rep(0, n)
        event <- x[, 2]
    }
    
    n <- length(exit)
    if (is.null(strata)) group <- rep(1, n)
    else group <- strata
    if (is.factor(group)){
        strata <- levels(group)
    }else{
        group <- as.character(group)
        strata <- sort(unique(group))
    }
    noOfGroups <- length(strata)
    if (noOfGroups > 1) limits <- FALSE 
    
    fn <- fn[1] # What type of plot?
    ##
    
    times <- list()
    atoms <- list()
    
    i <- 0
    ##if (is.null(xlim)){
        x.min <- min(enter)
        x.max <- max(exit)
        if (fn == "loglog"){
            x.min <- log(min(exit) / 2)
            x.max <- log(x.max)
        }
    if (is.null(xlim))  xlim <- c(x.min, x.max)
    ##}
    if (is.null(ylim)){
        y.max <- -1e103
        y.min <- 1.e103
    }

    yVal <- function(x){
        if (fn == "cum") return(cumsum(x))
        if (fn %in% c("log", "loglog")) return(log(cumsum(x)))
        n <- length(x)
        s <- numeric(n)
        s[1] <- 1 - x[1]
        if (n > 1){
            for (rs in 2:n){
                s[rs] <- s[rs - 1] *(1 - x[rs])
            }
        }
        return(s)
    }
    
    for (stratum in strata){
        i <- i + 1
        atom <- table.events(enter[group == stratum],
                             exit[group == stratum],
                             event[group == stratum]
                             )
        times[[i]] <- atom$times
        atoms[[i]] <- atom$events / atom$riskset.sizes
        if (fn %in% c("surv", "cum")){
            times[[i]] <- c(x.min, times[[i]])
            atoms[[i]] <- c(0, atoms[[i]])
        }
        nat <- length(times[[i]])
        mnat <- max(exit[group == stratum])
        if (times[[i]][nat] < mnat){
            times[[i]] <- c(times[[i]], mnat)
            atoms[[i]] <- c(atoms[[i]], 0)
        }
        if (fn == "loglog") times[[i]] <- log(times[[i]])
        atoms[[i]] <- yVal(atoms[[i]])
        if (is.null(ylim) && (fn != "surv")){
            y.max <- max(y.max, atoms[[i]][nat])
            y.min <- min(y.min, atoms[[i]][i])
        }
    }

    if (is.null(ylim)){
        if (fn == "surv"){
            y.min <- 0
            y.max <- 1
            ylim <- c(0, 1)
        }else{
            if (fn == "cum") y.min <- 0
            ylim <- c(y.min, y.max)
        }
    }

    if (is.null(ylab)) ylab <- ""
    if (is.null(xlab)) xlab <- "Duration"
    if (is.null(main)){
        if (fn == "cum") main <- "Cumulative hazard function"
        else if (fn == "surv") main <- "Survivor function"
        else{
            main <- "Log cumulative hazard function"
            if (fn == "loglog") xlab <- "Log(duration)"
        }
    }

    plot(times[[1]], atoms[[1]],
         main = main, xlab = xlab, ylab = ylab,
         xlim = xlim, ylim = ylim, type = "s", lty = 1, col = 1, ...)
    if (noOfGroups > 1){
        for (st in 2:noOfGroups){
            lines(times[[st]], atoms[[st]], type = "s", lty = st, col = st)
        }
        x <- 0.7 * (x.max - x.min) + x.min
        if (fn == "surv"){
            y <- 0.9 * (y.max - y.min) + y.min
        }else{
            y <- 0.4 * (y.max - y.min) + y.min
        }
        ##cat("x = ", x, ", y = ", y, "\n")
        legend(x, y, legend = strata,
               lty = 1:noOfGroups,
               col = 1:noOfGroups)            
    }

    if (fn %in% c("surv", "cum") & x.axis) abline(h = 0)

    if (limits && (fn == "surv")){
        q.alpha <- abs(qnorm((1 - conf) / 2))
        survived <- (atom$riskset.size - atom$events)
        se <- sqrt(cumsum(atom$events /
                          ( atom$riskset.sizes * survived )
                          )
                   )/
                       cumsum(-log(survived / atom$riskset.sizes))
        se <- c(0, se)
        surv <- atoms[[1]]
        n <- length(se)
        if (length(surv) > n) se <- c(se, se[n])
        upper <- surv ^ exp(q.alpha * se)
        lower <- surv ^ exp(-q.alpha * se)
        n <- length(upper)
        if (length(times[[1]]) > n){
            upper <- c(upper, upper[n])
            lower <- c(lower, upper[n])
        }
        if (is.null(lty.con)) {lty.con=2}
        if (is.null(col.con)) {col.con=2}
        lines(times[[1]], upper, type = "s", lty = lty.con, col = col.con)
        lines(times[[1]], lower, type = "s", lty = lty.con, col = col.con)
        ##lines(times[[1]], upper, type = "s", lty = 2, col = 2)
        ##lines(times[[1]], lower, type = "s", lty = 2, col = 2)
    }
}
    
                                           
            
