% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{ego_density}
\alias{ego_density}
\alias{ego_density.egor}
\title{Calculate the relationship density in ego-centered networks}
\usage{
ego_density(object, ...)

\method{ego_density}{egor}(object, weight = NULL, max.netsize = NULL, directed = FALSE, ...)
}
\arguments{
\item{object}{An \code{egor} object.}

\item{...}{arguments to be passed to methods}

\item{weight}{\code{Character} naming a variable containing the weight values
of relations. Weights should range from 0 to 1.}

\item{max.netsize}{Optional parameter. Constant value used if the
number of alters whose relations were collected is limited.}

\item{directed}{logical indicating if the alter-alter relation data/ edges
are directed or un-directed.}
}
\value{
returns a \code{vector} of network density values.
}
\description{
This function uses an \code{egor} object and calculates the density of all
the ego-centered networks listed in the 'egor' object. Instead of an
\code{egor} object, alter and alter-alter data can be provided as \code{lists}
or \code{data.frames}.
}
\examples{
data("egor32")
ego_density(egor32)
}
\keyword{analysis}
\keyword{ego-centered}
\keyword{network}
