% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_dimensions.R
\name{get_start_date}
\alias{get_start_date}
\title{Retrieves the first date of the time dimension from a netCDF file}
\usage{
get_start_date(time_units, time_zone = "UTC")
}
\arguments{
\item{time_units}{The string description of the units of the time dimension e.g. 'days since 1980-01-01' or 'hours since 2010-08-01 13:00:00 +0000'}

\item{time_zone}{the time zone to use for the returned value.}
}
\value{
A POSIXct object, origin of the time dimension as defined
}
\description{
Retrieves the first date of the time dimension from a netCDF file of daily data, given the units found in the netCDF attribute for the time dimension
}
\examples{

x <- "hours since 2015-10-04 00:00:00 +1023"
get_start_date(x)
get_start_date(x,time_zone = 'UTC')
get_start_date(x,time_zone = 'Australia/Perth')
get_start_date(x,time_zone = 'Australia/Canberra')

}
