% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_utils.R
\name{eem_extract}
\alias{eem_extract}
\title{Extract EEM samples}
\usage{
eem_extract(eem, sample, keep = FALSE, ignore_case = FALSE,
  verbose = TRUE)
}
\arguments{
\item{eem}{An object of class \code{eemlist}.}

\item{sample}{Either numeric of character vector. See \code{details} for more
information.}

\item{keep}{logical. If TRUE, the specified \code{sample} will be returned.
If FALSE, they will be removed.}

\item{ignore_case}{Logical, should sample name case should be ignored (TRUE)
or not (FALSE). Default is FALSE.}

\item{verbose}{Logical determining if removed/extracted eems should be
printed on screen.}
}
\value{
An object of class \code{eemlist}.
}
\description{
Extract EEM samples
}
\details{
\code{sample} argument can be either numeric or character vector. If
  it is numeric, samples at specified index will be removed.

  If \code{sample} is character, regular expression will be used and all
  sample names that have a partial or complete match with the expression will
  be removed. See \code{examples} for more details.
}
\examples{
folder <- system.file("extdata/cary/scans_day_1", package = "eemR")
eems <- eem_read(folder, import_function = "cary")

eems

# Remove first and third samples
eem_extract(eems, c(1, 3))

# Remove everything except first and third samples
eem_extract(eems, c(1, 3), keep = TRUE)

# Remove all samples containing "3" in their names.
eem_extract(eems, "3")

# Remove all samples containing either character "s" or character "2" in their names.
eem_extract(eems, c("s", "2"))

# Remove all samples containing "blank" or "nano"
eem_extract(eems, c("blank", "nano"))
}
