% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_correction.R
\name{eem_remove_blank}
\alias{eem_remove_blank}
\title{Blank correction}
\usage{
eem_remove_blank(eem, blank = NA)
}
\arguments{
\item{eem}{An object of class \code{eemlist}.}

\item{blank}{An object of class \code{eemlist}.}
}
\value{
An object of class \code{eemlist}.
}
\description{
This function is used to remove blank from eems which can help to reduce the
effect of scatter bands.
}
\details{
The function will first try to use the provided \code{blank}. If the
  blank is omited, the function will then try to extract the blank from the
  \code{eemlist} object. This is done by looking for sample names containing
  one of these complete or partial strings (ignoring case):

  \enumerate{ \item nano \item miliq \item milliq \item mq \item blank }

  Note that if \code{blank} is omited, the function will group the
  \code{eemlist} based on file location and will assumes that there is a
  blank sample in each folder. In that context, the blank will be used on
  each sample in the same folder.

  Consider the following example where there are two folders that could
  represent scans performed on two different days `scans_day_1` and
  `scans_day_2`.

  \tabular{ll}{
  scans_day_1\tab\cr
  \tab nano.csv\cr
  \tab sample1.csv\cr
  \tab sample2.csv\cr
  \tab sample3.csv\cr
  scans_day_2 \tab\cr
  \tab blank.csv\cr
  \tab s1.csv\cr
  \tab s2.csv\cr
  \tab s3.csv\cr
  }

  In each folder there are three samples and one blank files. In that
  context, `eem_remove_blank()` will use the blank `nano.csv` from
  `sample1.csv`, `sample2.csv` and `sample3.csv`. The same strategy will be
  used for files in folder `scans_day_2` but with blank named `blank.csv`.

  Note that the blanks eem are not returned by the function.
}
\examples{

## Example 1

# Open the fluorescence eem
file <- system.file("extdata/cary/scans_day_1", "sample1.csv", package = "eemR")
eem <- eem_read(file)

plot(eem)

# Open the blank eem
file <- system.file("extdata/cary/scans_day_1", "nano.csv", package = "eemR")
blank <- eem_read(file)

plot(blank)

# Remove the blank
eem <- eem_remove_blank(eem, blank)

plot(eem)

## Example 2

# Open the fluorescence eem
folder <- system.file("extdata/cary/scans_day_1", package = "eemR")
eems <- eem_read(folder)

plot(eems, which = 3)

# Open the blank eem
file <- system.file("extdata/cary/scans_day_1", "nano.csv", package = "eemR")
blank <- eem_read(file)

plot(blank)

# Remove the blank
eem <- eem_remove_blank(eems, blank)

plot(eems, which = 3)

# Automatic correction
folder <- system.file("extdata/cary/", package = "eemR")

# Look at the folder structure
list.files(folder, "*.csv", recursive = TRUE)

eems <- eem_read(folder, recursive = TRUE)
res <- eem_remove_blank(eems)
}
\references{
Murphy, K. R., Stedmon, C. a., Graeber, D., & Bro, R. (2013).
  Fluorescence spectroscopy and multi-way techniques. PARAFAC. Analytical
  Methods, 5(23), 6557. http://doi.org/10.1039/c3ay41160e

  \url{http://xlink.rsc.org/?DOI=c3ay41160e}
}

