% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_export.R
\name{eem_export_matlab}
\alias{eem_export_matlab}
\title{Export EEMs to Matlab}
\usage{
eem_export_matlab(file, ...)
}
\arguments{
\item{file}{The .mat file name where to export the structure.}

\item{...}{One or more object of class \code{eemlist}.}
}
\value{
A structure named \code{OriginalData} is created and contains:

  \describe{ \item{nSample}{The number of eems.} \item{nEx}{The number of
  excitation wavelengths.} \item{nEm}{The number of emission wavelengths.}
  \item{Ex}{A vector containing excitation wavelengths.} \item{Em}{A vector
  containing emission wavelengths.} \item{X}{A 3D matrix (nSample X nEx X
  nEm) containing EEMs.} }

  \code{sample_name} The list of sample names (i.e. file names) of the
  imported EEMs.
}
\description{
Export EEMs to Matlab
}
\details{
The function exports EEMs into PARAFAC-ready Matlab \code{.mat} file
  usable by the \href{www.models.life.ku.dk/drEEM}{drEEM} toolbox.
}
\examples{
file <- system.file("extdata/cary/", package = "eemR")
eem <- eem_read(file, recursive = TRUE)

export_to <- paste(tempfile(), ".mat", sep = "")
eem_export_matlab(export_to, eem)
}

