% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absorbance.R
\docType{data}
\name{absorbance}
\alias{absorbance}
\title{CDOM absorbance data.}
\format{A data frame with 711 rows and 4 variables}
\usage{
data("absorbance")
}
\description{
Simple absorbance spectra used to test package's functions.
}
\details{
\itemize{
  \item wavelength.  Wavelengths used for measurements (190-900 nm.)
  \item absorbance
}
}
\examples{
library(ggplot2)
library(tidyr)

data("absorbance")

absorbance <- gather(absorbance, sample, absorbance, -wavelength)

ggplot(absorbance, aes(x = wavelength, y = absorbance, group = sample)) +
 geom_line(aes(color = sample), size = 0.1)
}
\keyword{datasets}

