% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nat_data16}
\alias{nat_data16}
\title{Data and centroids corresponding to the Australian Electorates from 2016}
\format{A data frame with 150 rows with the following variables:
\itemize{
    \item id: Numeric identifier for the polygon
    \item elect_div: Electorate division name   
    \item state: abbreviation of the state name
    \item numccds: AEC variable that might be filled with meaning or a description down the road
    \item area_sqkm: combined square kilometers of each electorate
    \item long_c: longitude coordinate of electorate (polygon) centroid
    \item lat_c: latitude coordinate of electorate (polygon) centroid
    \item x: latitude coordinate for plotting a cartogram
    \item y: longitude coordinate for plotting a cartogram
    \item radius: variable used in the construction of cartogram points
}}
\usage{
nat_data16
}
\description{
A dataset containing some demographic information for each of the 150 Australian electorates.
The data were obtained from the Australian Electoral Commission, and downloaded 
from \url{http://www.aec.gov.au/Electorates/gis/gis_datadownload.htm}.
Must be loaded using the `nat_data_download` function.
}
\examples{

library(eechidna)
library(tidyverse)
library(ggthemes)
nat_map16 <- nat_map_download(2016)
data(fp16)
winners <- fp16 \%>\% filter(Elected == "Y")

# Combine Liberal and National parties
winners <- winners \%>\% 
mutate(PartyNm = ifelse(PartyNm \%in\% c("NATIONAL PARTY", "LIBERAL PARTY"), 
"LIBERAL NATIONAL COALITION", PartyNm))

# Join to map
nat_data16 <- nat_data_download(2016)
nat_data16$DivisionNm <- toupper(nat_data16$elect_div)
nat_data16 <- nat_data16 \%>\% left_join(winners, by = "DivisionNm")
# Plot
partycolours = c("#FF0033", "#000000", "#CC3300", "#0066CC", "#FFFF00", "#009900")

ggplot(data=nat_map16) + 
geom_polygon(aes(x=long, y=lat, group=group), fill="grey90", colour="white") +
geom_point(data=nat_data16, aes(x=x, y=y, colour=PartyNm), size=1.5, alpha=0.8) +
scale_colour_manual(name="Political Party", values=partycolours) +
theme_map() + coord_equal() + theme(legend.position="bottom")
}
\keyword{datasets}
