% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header_search.R
\name{header_search}
\alias{header_search}
\title{SEC Header Search}
\usage{
header_search(q, page = 1, from = 1994, to = 2017)
}
\arguments{
\item{q}{The search string. Documentation
\href{here}{https://www.sec.gov/edgar/searchedgar/search_help.htm}}

\item{page}{Which results page to return (default: 1)}

\item{from}{Start year (default: 1994)}

\item{to}{End year (default: Current year)}
}
\value{
A dataframe of funds found including the following columns -
  \itemize{
    \item company_name
    \item filing_href
    \item form
    \item filing_date
    \item size
  }
}
\description{
Searches filing headers going back to 1994 excluding the most recent day
using the interface \href{here}{https://www.sec.gov/cgi-bin/srch-edgar}.
}
\examples{
\donttest{
## This can be very slow running
header_search("company-name = Apple")
}
}
