% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_filing.R
\name{parse_filing}
\alias{parse_filing}
\title{Parse Filing}
\usage{
parse_filing(x, strip = TRUE, include.raw = FALSE)
}
\arguments{
\item{x}{- URL to a filing HTML document, html text or xml_document}

\item{strip}{- Should non-text elements be removed? Default: true}

\item{include.raw}{- Include unprocessed nodes in result? Default: false}
}
\value{
a dataframe with one row per paragraph
  \describe{
    \item{part.name}{Detected name of the Part}
    \item{item.name}{Detected name of the Item}
    \item{text}{Text of the paragraph / node}
    \item{raw*}{Raw HTML of the node if \code{include.raw = TRUE}}
  }
}
\description{
Given a link to filing document (e.g. the 10-K, 8-K) in HTML, process the
file into parts and items. This enables follow-up processing of a desired
section - e.g. just the Risk Factors. `item.name` and `part.name` are taken
directly from the document without any attempt to normalize.
}
\details{
*NOTE:* This has been tested on a range of documents, but formatting
differences could cause failures. Please report an issue for any document
that isn't parsed correctly.
}
\examples{
head(parse_filing(paste0('https://www.sec.gov/Archives/edgar/data/',
     '712515/000071251517000010/ea12312016-q3fy1710qdoc.htm')), 6)
}
