% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/masterpull.R
\name{masterpull}
\alias{masterpull}
\title{A function to import EdBuild's master dataset}
\format{A data frame with 42 variables. To view descriptions of variable
  names and sources for each use \code{master_codebook()}}
\source{
\url{https://s3.amazonaws.com/data.edbuild.org/public/Processed+Data/Master/2018/full_data_18_type_exc.csv}
}
\usage{
masterpull(data_year = "2018", data_type = "gen", disaggregated =
  FALSE)
}
\arguments{
\item{data_year}{Four digit year of master data to pull in. Options include
2013- 2018. Defaults to 2018.}

\item{data_type}{Type of master data to pull in \itemize{ \item \code{geo}
pulls in all school districts that have physical school district
boundaries. To be used for map-based analysis and other analyses that
pertain to school districts with geographic boundaries. For instance, an
analysis using median owner-occupied property value would use the geography
exclusion. \item \code{fin} pulls in all school districts that meet
EdBuild’s criteria for financial analysis. To be used for finance analysis.
\item \code{gen} pulls in all school districts that meet enrollment and
district type requirements. To be used for all other, non-finance analysis.
\item \code{full} pulls in all school districts in the given year. To be
used with great care, or to find a district that does not appear in any
other exclusion, for example charter school districts. } Defaults to
\code{gen}}

\item{disaggregated}{For the full, general, and finance exclusions in 2018,
users have the option to view disaggregated Vermont school district data
without EdBuild's aggregation processing.}
}
\value{
A dataframe where each observation is a school district.
}
\description{
This function allows you to read in EdBuild's master dataset for the years
2013- 2018. The master dataset is a compilation of national level school
district data from the US Census Annual Survey of School System Finances
(F33); US Census Small Area Income and Poverty Estimates (SAIPE); National
Center for Education Statistics (NCES) Common Core of Data (CCD); and
Education Demographic and Geographic Estimates (EDGE). Cost adjustments were
calculated using C2ER.
}
\note{
There are three types of exclusions that can be applied to the master
  dataset:

  1. Geography based: \itemize{ \item Excludes districts that do not have
  physical school district boundaries and thus are not included in the US
  Census, EDGE shapefile. }

  2. Finance based: \itemize{ \item Excludes districts that are of types 5
  (vocational or special education), 6 (non-operating) or 7 (educational
  service agency) in the F33 data.

  \item If F33 school type is missing, excludes districts that are of types 4
  (regional education service agency), 5 (state agency), 6 (federal agency),
  7 (charter agency) or 8 (other education agency) based on CCD.

  \item Excludes districts that zero missing or total enrollments.

  \item Excludes districts that have missing or zero operational schools.

  \item Excludes districts that have missing revenues.

  \item Excludes districts that have very low revenues (<$500).

  \item Excludes districts that have very high revenues (>$100,000 in
  inflation-adjusted 2017 dollars).

  \item Excludes districts from the US territories. }

  3. General: \itemize{ \item Excludes districts that are of types 5
  (vocational or special education), 6 (nonoperating) or 7 (educational
  service agency) in the F33 data.

  \item If F33 school type is missing, excludes districts that are of types 4
  (regional education service agency), 5 (state agency), 6 (federal agency),
  7 (charter agency) or 8 (other education agency) based on CCD.

  \item Excludes districts that have missing or zero total enrollments.

  \item Excludes districts from the US territories. }
}
\examples{
\donttest{master18_geo <- masterpull("2018", data_type = "geo")}
}
\seealso{
\code{\link{master_codebook}}, \code{\link{long_masterpull}}
}
\keyword{CCD}
\keyword{EDGE}
\keyword{EdBuild}
\keyword{F33}
\keyword{SAIPE}
\keyword{data}
\keyword{master}
