% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prox.R
\name{extract_proximity}
\alias{extract_proximity}
\title{Methods to extract proximity matrices from random forests}
\usage{
extract_proximity(fit, newdata)
}
\arguments{
\item{fit}{object of class 'RandomForest', 'randomForest', 'rfsrc', or `ranger`}

\item{newdata}{new data with the same columns as the data used for \code{fit}}

\item{...}{arguments to be passed to \code{extract_proximity}}
}
\value{
an n x n matrix where position i, j gives the proportion of times observation i and j are in the same teriminal node across all trees
}
\description{
Extracts proximity matrices from random forest objects from the party, randomForest, randomForestSRC, or ranger packages
}
\examples{
library(randomForest)

fit = randomForest(hp ~ ., mtcars, proximity = TRUE)
extract_proximity(fit)

fit = randomForest(Species ~ ., iris, proximity = TRUE)
extract_proximity(fit)
}
\seealso{
\code{\link{plot_prox}} for plotting principal components of proximity matrices.
}
