% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dominates.R
\name{which.dominated}
\alias{which.dominated}
\alias{which.nondominated}
\title{Determine which points of a set are (non)dominated.}
\usage{
which.dominated(x)

which.nondominated(x)
}
\arguments{
\item{x}{[\code{matrix}]\cr
Numeric (n x d) matrix where n is the number of points and d is the number
of objectives.}
}
\value{
[\code{integer}]
}
\description{
Simple wrapper functions around \code{\link{dominated}}. Given a matrix with one
point per row \code{which.dominated} returns the row numbers of the dominated
points and \code{which.nondominated} the row numbers of the nondominated points.
}
\examples{
  data(mtcars)
  # assume we want to maximize horsepower and minimize gas consumption
  cars = mtcars[, c("mpg", "hp")]
  cars$hp = -cars$hp
  idxs = which.nondominated(as.matrix(cars))
  print(mtcars[idxs, ])
}
\keyword{optimize}

